#pragma once

#include "../Common/DeviceResources.h"
#include <map>
#include <memory>

class TextureAndSRVNV12;

class TextureMapper {
public:
    TextureMapper(std::shared_ptr<DX::DeviceResources> deviceResources, int defaultWidth, int defaultHeight);

    std::shared_ptr<TextureAndSRVNV12> Get() const;
    void Create(int width, int height);
    void SetActive(int width, int height);

    void Apply();
    void Reset();

    using WidthHeight = std::tuple<int, int>;
    using TextureMap = std::map<WidthHeight, std::shared_ptr<TextureAndSRVNV12>>;

protected:
private:
    std::shared_ptr<DX::DeviceResources> m_deviceResources;
    WidthHeight m_activeTexture;

    TextureMap m_textures;
};
