﻿#pragma once

#include <functional>
#include <string>
#include "Renderer.h"
#include "..\Common\DeviceResources.h"
#include "..\Common\StepTimer.h"

namespace nativeplayer {

class ControlRenderer : public Renderer {
public:
    ControlRenderer(const std::shared_ptr<DX::DeviceResources> &deviceResources, const std::string name, const std::function<void()> onClicked);
    ~ControlRenderer() override = default;

    void CreateDeviceDependentResources() override;
    void ReleaseDeviceDependentResources() override;

    void Update(DX::StepTimer const &timer) override;
    void Render() override;

    bool IsInWindow(Windows::Foundation::Point point) override;
    void OnPointerPressed(Windows::Foundation::Point point) override;
    void OnPointerReleased(Windows::Foundation::Point point) override;

protected:
    std::wstring                                    m_text;
    Microsoft::WRL::ComPtr<ID2D1SolidColorBrush>    m_background;
    Microsoft::WRL::ComPtr<ID2D1SolidColorBrush>    m_whiteBrush;

    DWRITE_TEXT_METRICS                             m_textMetrics;
    Microsoft::WRL::ComPtr<IDWRITETEXTLAYOUT>       m_textLayout;
    Microsoft::WRL::ComPtr<IDWRITETEXTFORMAT>       m_textFormat;
    D2D1_POINT_2F                                   m_position;

    static unsigned int                             ms_count;
    unsigned int                                    m_index;

    std::function<void()>                           m_onClicked;
};
}
