﻿#pragma once

#include <string>
#include "Renderer.h"
#include "..\Common\DeviceResources.h"
#include "..\Common\StepTimer.h"

namespace nativeplayer {

class DebugRenderer : public Renderer {
public:
    DebugRenderer(const std::shared_ptr<DX::DeviceResources> &deviceResources, twitch::Application & application);
    ~DebugRenderer() override = default;

    void CreateDeviceDependentResources() override;
    void ReleaseDeviceDependentResources() override;

    void Update(DX::StepTimer const &timer) override;
    void Render() override;

private:
    twitch::Application & m_application;

    // Resources related to text rendering.
    std::wstring                                    m_text;
    DWRITE_TEXT_METRICS                             m_textMetrics;
    Microsoft::WRL::ComPtr<ID2D1SolidColorBrush>    m_whiteBrush;
    Microsoft::WRL::ComPtr<ID2D1SolidColorBrush>    m_background;
    Microsoft::WRL::ComPtr<IDWRITETEXTLAYOUT>       m_textLayout;
    Microsoft::WRL::ComPtr<IDWRITETEXTFORMAT>       m_textFormat;
};
}
