﻿#include "pch.h"
#include "nativeplayer.hpp"
#include "Common/DirectXHelper.h"
#include "QualityButtonRenderer.h"

using namespace nativeplayer;
using namespace Microsoft::WRL;

QualityButtonRenderer::QualityButtonRenderer(const std::shared_ptr<DX::DeviceResources>& deviceResources, twitch::Application & application)
    : ControlRenderer(deviceResources, "Source", std::bind(&QualityButtonRenderer::switchQuality, this))
    , m_application(application)
{
}

// Updates the text to be displayed.
void QualityButtonRenderer::Update(DX::StepTimer const& timer)
{
    if (m_isSpinning) {
        m_timeForNextSpin -= timer.GetElapsedSeconds();
        if (m_timeForNextSpin <= 0.f) {
            m_timeForNextSpin = TimePerSpin;
            switch (m_currentSpin[0]) {
            case '|':
                m_currentSpin = "/";
                break;
            case '/':
                m_currentSpin = "-";
                break;
            case '-':
                m_currentSpin = "\\";
                break;
            case '\\':
                m_currentSpin = "|";
                break;
            }
        }
        m_text = stringtowstring("(" + m_currentSpin + ")\n" + m_targetQuality);
    }
    else
    {
        m_text = stringtowstring(m_targetQuality);
    }

    ControlRenderer::Update(timer);
}

void QualityButtonRenderer::switchQuality()
{
    auto mediaPlayer = m_application.getMediaPlayer();

    auto currentQuality = mediaPlayer->getQuality();
    auto availableQualities = mediaPlayer->getQualities();

    int index = -1;
    for (int i = 0; i < availableQualities.size(); ++i) {
        if (availableQualities[i] == currentQuality) {
            index = i;
            break;
        }
    }

    // couldn't even find your own quality, what ?
    if (index == -1)
        return;

    // cycle to the next
    index++;
    index %= availableQualities.size();

    mediaPlayer->setQuality(availableQualities[index]);

    m_isSpinning = true;
    m_timeForNextSpin = TimePerSpin;
    m_targetQuality = availableQualities[index].name;
}

const double nativeplayer::QualityButtonRenderer::TimePerSpin = 0.10f;
