﻿#pragma once
#include <string>
#include "ControlRenderer.h"
#include "..\Common\DeviceResources.h"
#include "..\Common\StepTimer.h"

namespace twitch {
class Application;
}

namespace nativeplayer {

class QualityButtonRenderer : public ControlRenderer {
public:
    QualityButtonRenderer(const std::shared_ptr<DX::DeviceResources> &deviceResources, twitch::Application & application);
    ~QualityButtonRenderer() override = default;

    void Update(DX::StepTimer const &timer) override;

private:
    void switchQuality();

private:
    twitch::Application & m_application;

    std::string m_targetQuality;
    std::string m_currentSpin = "|";
    bool m_isSpinning = true;
    static const double TimePerSpin;
    double m_timeForNextSpin = TimePerSpin;
};
}
