﻿#pragma once

#include "..\Common\DeviceResources.h"
#include "..\Common\StepTimer.h"
#include "..\Common\TextureAndSRVNV12.hpp"
#include "..\Common\TextureMapper.hpp"

#include "Renderer.h"
#include "ShaderStructures.h"

#include <mutex>

namespace nativeplayer {

// This sample renderer instantiates a basic rendering pipeline.
class Sample3DSceneRenderer : public Renderer {
public:
    Sample3DSceneRenderer(const std::shared_ptr<DX::DeviceResources> &deviceResources, twitch::Application & application);
    ~Sample3DSceneRenderer() override;

    void CreateDeviceDependentResources() override;
    void CreateWindowSizeDependentResources() override;
    void ReleaseDeviceDependentResources() override;

    void Update(DX::StepTimer const &timer) override;
    void Render() override;

    void StartTracking();
    void TrackingUpdate(Windows::Foundation::Point position);
    void StopTracking();
    bool IsTracking() { return m_tracking; }

    static const UINT DefaultTextureWidth = 1920;
    static const UINT DefaultTextureHeight = 1088;
private:
    void SetOnRenderCallback();
    void UpdateTexture();
private:
    twitch::Application & m_application;

    // Direct3D resources for cube geometry.
    Microsoft::WRL::ComPtr<ID3D11InputLayout>   m_inputLayout;
    Microsoft::WRL::ComPtr<ID3D11Buffer>        m_vertexBuffer;
    Microsoft::WRL::ComPtr<ID3D11Buffer>        m_indexBuffer;
    Microsoft::WRL::ComPtr<ID3D11VertexShader>  m_vertexShader;
    Microsoft::WRL::ComPtr<ID3D11PixelShader>   m_pixelShader;
    Microsoft::WRL::ComPtr<ID3D11Buffer>        m_constantBuffer;

    // Texture stuff
    std::shared_ptr<TextureMapper> m_textureMapper;

    // System resources for cube geometry.
    ModelViewProjectionConstantBuffer   m_constantBufferData;
    uint32_t  m_indexCount;

    // Variables used with the rendering loop.
    bool    m_firstUpdateDone = false;
    bool    m_textureUpdated = false;
    bool    m_loadingComplete;
    bool    m_tracking;

    struct ImageInfo
    {
        Microsoft::WRL::ComPtr<ID3D11Texture2D> imageTexture;
        int imageWidth = 0;
        int imageHeight = 0;
    };

    std::mutex m_imageMutex;
    ImageInfo m_image;
};
}
