﻿#pragma once

#include <string>
#include "Renderer.h"
#include "..\Common\DeviceResources.h"
#include "..\Common\StepTimer.h"

namespace nativeplayer {

class TimelineRenderer : public Renderer {
public:
    TimelineRenderer(const std::shared_ptr<DX::DeviceResources> &deviceResources, twitch::Application & application);
    ~TimelineRenderer() override = default;

    void CreateDeviceDependentResources() override;
    void ReleaseDeviceDependentResources() override;

    void Update(DX::StepTimer const &timer) override;
    void Render() override;

    bool IsInWindow(Windows::Foundation::Point point) override;
    void OnPointerPressed(Windows::Foundation::Point point) override;
    void OnPointerReleased(Windows::Foundation::Point point) override;
private:
    static const unsigned int TIMELINE_STEP_COUNT = 11;
    const float TIME_STEP_WIDTH = 200.0f;
    const float TIME_STEP_HEIGHT = 25.0f;

    twitch::Application & m_application;

    Microsoft::WRL::ComPtr<ID2D1SolidColorBrush>    m_alphaBrush;
    Microsoft::WRL::ComPtr<ID2D1SolidColorBrush>    m_whiteBrush;
    Microsoft::WRL::ComPtr<ID2D1SolidColorBrush>    m_background;
    Microsoft::WRL::ComPtr<ID2D1SolidColorBrush>    m_yellowBrush;

    std::wstring                                    m_text[TIMELINE_STEP_COUNT];
    Microsoft::WRL::ComPtr<IDWRITETEXTLAYOUT>       m_textLayout[TIMELINE_STEP_COUNT];
    Microsoft::WRL::ComPtr<IDWRITETEXTFORMAT>       m_textFormat;

    D2D1_RECT_F m_bounds;
};
}
