﻿#pragma once

#include <list>

#include "Common\StepTimer.h"
#include "Common\DeviceResources.h"
#include "Content\Sample3DSceneRenderer.h"

// Renders Direct3D content on the screen.
namespace nativeplayer {

class nativeplayerMain : public DX::IDeviceNotify {
public:
    nativeplayerMain(const std::shared_ptr<DX::DeviceResources> &deviceResources, twitch::Application & application);
    ~nativeplayerMain();
    void CreateWindowSizeDependentResources();
    void Update();
    bool Render();

    // IDeviceNotify
    virtual void OnDeviceLost();
    virtual void OnDeviceRestored();

    // Pointer tracking
    void StartTracking() { m_sceneRenderer->StartTracking(); }
    void TrackingUpdate(Windows::Foundation::Point position) { m_pointerLocation = position; }
    void StopTracking() { m_sceneRenderer->StopTracking(); }
    bool IsTracking() { return m_sceneRenderer->IsTracking(); }

    void OnPointerPressed(Windows::Foundation::Point point);
    void OnPointerReleased(Windows::Foundation::Point point);
private:
    void ProcessInput();

    std::list<std::shared_ptr<Renderer>> m_renderers;

    // Cached pointer to device resources.
    std::shared_ptr<DX::DeviceResources> m_deviceResources;

    std::unique_ptr<Sample3DSceneRenderer> m_sceneRenderer;

    // Rendering loop timer.
    DX::StepTimer m_timer;

    // Track current input pointer position.
    Windows::Foundation::Point m_pointerLocation;
};
}
