#pragma once

#include "targetver.h"

#define WIN32_LEAN_AND_MEAN

// Windows header files
#include <windows.h>
#include <windowsx.h>
#include <combaseapi.h>
#include <comdef.h>
#include <wrl.h>
#include <tchar.h>
#include <wincodec.h>
#include <PathCch.h>

// DirectX header files
// https://docs.microsoft.com/en-us/windows/desktop/direct3darticles/platform-update-for-windows-7
#include <dxgi1_2.h>
#include <d3d11_1.h>
#include <d2d1_1.h>
#include <d2d1effects_1.h>
#include <dwrite_1.h>
#include <DirectXColors.h>
#include <DirectXMath.h>

// C++ library header files
#include <fstream>
#include <future>
#include <iterator>
#include <memory>
#include <stdexcept>
#include <string>

#define CD3D11_TEXTURE2D_DESCX CD3D11_TEXTURE2D_DESC
#define ID2D1DEVICE ID2D1Device
#define ID2D1DEVICECONTEXT ID2D1DeviceContext
#define ID2D1FACTORY ID2D1Factory1
#define ID3D11DEVICE ID3D11Device1
#define ID3D11DEVICECONTEXT ID3D11DeviceContext1
#define ID3D11RENDERTARGETVIEW ID3D11RenderTargetView
#define ID3D11TEXTURE2D ID3D11Texture2D
#define IDWRITEFACTORY IDWriteFactory1
#define IDWRITETEXTFORMAT IDWriteTextFormat
#define IDWRITETEXTLAYOUT IDWriteTextLayout1
#define IDXGIDEVICE IDXGIDevice2
#define IDXGIFACTORY IDXGIFactory2
#define IDXGISWAPCHAIN IDXGISwapChain1
#define CreateRenderTargetViewX CreateRenderTargetView
#define CreateTexture2DX CreateTexture2D

namespace Windows {
	namespace Foundation {
		struct Point {
			LONG X, Y;
		};

		struct Size {
			float Width, Height;

			bool operator!=(Size const& that) const {
				return Width != that.Width || Height != that.Height;
			}
		};
	}
}

using WindowRef = HWND;

DECLSPEC_NORETURN inline void ThrowFailure(HRESULT hr) {
	_com_raise_error(hr);
}

DECLSPEC_NORETURN inline void ThrowFailure(char const* message) {
	throw std::runtime_error(message);
}
