#pragma once

namespace twitch {
/**
 * Represents a cancellable operation.
 */
class Cancellable {
public:
    Cancellable() = default;
    virtual ~Cancellable() = default;

    /**
     * Cancels the operation. In some cases this method may block until the operation can be
     * cancelled successfully in order to ensure the operation is not running after the method call.
     */
    virtual void cancel() = 0;
};
}
