#pragma once

#include "MediaResult.hpp"
#include <cstdint>
#include <string>

namespace twitch {
/** Represents the source component of an error code */
enum class ErrorSource {
    /** Unspecified source */
    Unspecified,
    /** Error reading or opening a media file */
    File,
    /** Error downloading or parsing a media playlist */
    Playlist,
    /** Error downloading or parsing a media segment */
    Segment,
    /** Error from the media source */
    Source,
    /** Error from a MediaDecoder */
    Decode,
    /** Error from a MediaRenderer */
    Render,
};

/**
 * @param result to get the string representation of
 * @return string constant for the given result
 */
const char* errorSourceString(ErrorSource result);

/** Error data type */
struct Error {
    /**
     * Creates an error with the given parameters
     * @param source error source
     * @param result type
     * @param message error message
     */
    Error(ErrorSource source, MediaResult result, const std::string& message)
        : source(source)
        , result(result)
        , message(message)
    {
    }
    /** Source of the error */
    ErrorSource source;
    /** Error result type */
    MediaResult result;
    /** Error message */
    std::string message;
};
}
