#pragma once

#include "playercore/MediaTime.hpp"
#include "playercore/MediaType.hpp"
#include <cstdint>
#include <vector>

namespace twitch {
/** Represents a sample of media, including a meta data and time stamps. */
struct MediaSample {
    virtual ~MediaSample() = default;

    /** time stamp for the sample */
    MediaTime decodeTime = MediaTime::zero();

    /** Presentation time stamp for the sample (optional) */
    MediaTime presentationTime = MediaTime::zero();

    /** Duration of the sample in microseconds */
    MediaTime duration = MediaTime::zero();

    /** true if this sample is sync sample in the stream e.g. keyframe in a video sample */
    bool isSyncSample = false;

    /** true if this sample is a discontinuity in the stream */
    bool isDiscontinuity = false;

    /** true if this sample will be decoded but not rendered, typically this only needs to be
     * checked for video samples */
    bool isDecodeOnly = false;

    enum Type : uint32_t {
        /** sample contains plain byte buffer */
        MemoryBuffer = 0,
        /** sample contains a handle to an opaque data type (generally platform specific) */
        Opaque = 0x1,
        /** sample contains encrypted byte buffer */
        EncryptedMemoryBuffer = 0x2,
    };

    /** type of this sample */
    uint32_t type = Type::Opaque;
};
/** Represents a sample of media as a vector of bytes */
class MediaSampleBuffer : public MediaSample {
public:
    MediaSampleBuffer() { type = Type::MemoryBuffer; }
    ~MediaSampleBuffer() override = default;

    /** buffer of sample data */
    using BufferType = std::vector<uint8_t>;
    BufferType buffer;
};
}
