#pragma once

#include <string>

namespace twitch {
/**
 * Represents a stream quality which is a selection of video/audio tracks from a MediaSource
 */
struct Quality {

    /** name of the quality, suitable for use in a user interface */
    std::string name;

    /** type of the stream (e.g. audio/video) */
    std::string type;

    /** group this quality belongs to (if any) */
    //[[deprecated]] // for web backwards compatibility only
    std::string group;

    /** codecs used in this quality */
    std::string codecs;

    /** bit rate of this stream */
    int bitrate = 0;

    /** frame rate of this stream if known 0 otherwise */
    float framerate = 0;

    /** video width or zero if unknown or not applicable */
    int width = 0;

    /** video height or zero if unknown or not applicable */
    int height = 0;

    /** True if this quality should be used in auto selection */
    bool autoSelect = true;

    /** True if this quality should be considered the default */
    bool isDefault = false;

    bool operator<(const Quality& other) const { return bitrate < other.bitrate; }

    bool operator==(const Quality& other) const
    {
        return name == other.name
            && bitrate == other.bitrate;
    }

    bool operator!=(const Quality& other) const { return !(*this == other); }
};
}
