#pragma once

#include "playercore/MediaTime.hpp"
#include "playercore/MediaType.hpp"

namespace twitch {
/** Reference clock interface used for media synchronization */
class ReferenceClock {
public:
    virtual ~ReferenceClock() = default;

    /** @return the elapsed presentation time  */
    virtual MediaTime getElapsedMediaTime() const = 0;

    /** @return the elapsed wall clock time */
    virtual MediaTime getElapsedWallClockTime() const = 0;

    /** @return current media time (used for for synchronization) */
    virtual MediaTime getMediaTime() const = 0;

    /** @return the current playback rate */
    virtual float getPlaybackRate() const = 0;

    /** @return the current monotonic time, suitable for measuring elapsed time */
    virtual MediaTime now() const = 0;

    /** starts the clock */
    virtual void start() = 0;

    /** stops the clock */
    virtual void stop() = 0;
};
}
