#pragma once

#include "playercore/MediaSample.hpp"
#include <cstdint>

namespace twitch {
/**
 * Represents a partially or fully encrypted sample buffer. Which may contain a mix of clear or
 * encrypted sub-samples. Based on ISO/IEC 23001-7: Common Encryption standard, maps on to the data
 * in the `senc` sample encryption data in an MP4.
 */
class SecureSampleBuffer : public MediaSampleBuffer {
public:
    SecureSampleBuffer() { type = Type::EncryptedMemoryBuffer; }
    ~SecureSampleBuffer() override = default;

    /** initialization vector */
    std::vector<uint8_t> initializationVector;

    /** key id */
    std::vector<uint8_t> keyId;

    /** bytes of clear/protected data for a given subsample */
    std::vector<std::pair<uint16_t, uint32_t>> subsampleRange;

    /** AES block cipher mode */
    enum CipherMode {
        CTR,
        CBC
    };
    /** AES block cipher mode of the encrypted data */
    CipherMode mode = CipherMode::CTR;
};
}
