#pragma once

namespace twitch {
/** Playback statistics for video */
class Statistics {
public:
    Statistics() = default;
    virtual ~Statistics() = default;

    /** Current framerate being rendered or 0 if not rendered  */
    virtual int getFrameRate() const = 0;

    /** Current bitrate */
    virtual int getBitRate() const = 0;

    /** Number of frames decoded */
    virtual int getDecodedFrames() const = 0;

    /** Number of frames dropped (not rendered) */
    virtual int getDroppedFrames() const = 0;

    /** Number of frames rendered */
    virtual int getRenderedFrames() const = 0;
};
}
