#pragma once

#include <limits>

namespace twitch {
/** Defines the AVC sample format the platform decoder can accept */
enum class AVCFormatType {
    AVCC, /** Size prefixed NAL units */
    AnnexB, /** Annex B start code prefixed NAL units */
};

struct Capabilities {
    /** AVC format sample type expected by the platform decoder */
    AVCFormatType avcFormat = AVCFormatType::AnnexB;

    /** True if platform can decode single frame fragments */
    bool supportsSingleFrameFragments = true;

    /** True if platform exposes sufficient network information */
    bool supportsLowLatencyABR = false;

    /** True if platform supports speedup */
    bool supportsSpeedUp = false;

    /** True if the platform has accurate http response timing */
    bool supportsHttpResponseTiming = true;

    /** True if the platform sink supports overwriting the buffer */
    bool supportsBufferOverwrite = false;

    Capabilities() {}
};
}
