#pragma once

#include <string>

#undef DELETE

namespace twitch {
/** Enumeration of HTTP method types per https://tools.ietf.org/html/rfc7231#section-4.3 */
enum class HttpMethod {
    CONNECT,
    GET,
    OPTIONS,
    POST,
    PUT,
    PATCH,
    DELETE,
};

inline const char* httpMethodToString(HttpMethod method)
{
    switch (method) {
    case HttpMethod::CONNECT:
        return "CONNECT";
    default:
    case HttpMethod::GET:
        return "GET";
    case HttpMethod::OPTIONS:
        return "OPTIONS";
    case HttpMethod::POST:
        return "POST";
    case HttpMethod::PUT:
        return "PUT";
    case HttpMethod::PATCH:
        return "PATCH";
    case HttpMethod::DELETE:
        return "DELETE";
    }
}
}
