#pragma once

#include <string>

namespace twitch {
/** Enumeration of HTTP status codes defined per https://tools.ietf.org/html/rfc7231#section-6.1 */
enum HttpStatus : int {
    HttpStatusContinue = 100,
    HttpStatusOk = 200,
    HttpStatusCreated = 201,
    HttpStatusAccepted = 202,
    HttpStatusNoContent = 204,
    HttpStatusResetContent = 205,
    HttpStatusPartialContent = 206,
    HttpStatusMultiStatus = 207,
    HttpStatusMultipleChoices = 300,
    HttpStatusMovedPermanently = 301,
    HttpStatusFound = 302,
    HttpStatusNotModified = 304,
    HttpStatusTemporaryRedirect = 307,
    HttpStatusPermanentRedirect = 308,
    HttpStatusBadRequest = 400,
    HttpStatusUnauthorized = 401,
    HttpStatusForbidden = 403,
    HttpStatusNotFound = 404,
    HttpStatusMethodNotAllowed = 405,
    HttpStatusConflict = 409,
    HttpStatusGone = 410,
    HttpStatusLengthRequired = 411,
    HttpStatusPreconditionFailed = 412,
    HttpStatusRequestedRangeNotSatisfiable = 416,
    HttpStatusTooManyRequests = 429,
    HttpStatusInternalServerError = 500,
    HttpStatusBadGateway = 502,
    HttpStatusServiceUnavailable = 503,
    HttpStatusGatewayTimeout = 504,
    HttpStatusBandwidthLimitExceeded = 509,
};
}
