#pragma once

#include <limits>

namespace twitch {
struct VideoDecoderCapabilities {
    VideoDecoderCapabilities() {}
    using limits_int = std::numeric_limits<int>;

    /** Max decodable bit rate */
    int maxBitrate = limits_int::max();

    /** Max displayable frame rate */
    int maxFramerate = limits_int::max();

    /** Max displayable video width */
    int maxWidth = limits_int::max();

    /** Max displayable video height */
    int maxHeight = limits_int::max();

    /** Max decodable profile */
    int maxProfile = limits_int::max();

    /** Max decodable level */
    int maxLevel = limits_int::max();
};
}
