#pragma once

#include "playercore/MediaRenderer.hpp"

namespace twitch {
/**
 * Video renderer interface extending MediaRenderer with additional methods specifically for video
 * playback.
 */
class VideoRenderer : public MediaRenderer {
public:
    ~VideoRenderer() override = default;
    /**
     * Gets the number of dropped frames (this value should reset to zero on flush()).
     * @param count out parameter number of dropped (non-rendered) frames
     */
    virtual MediaResult getDroppedFrames(int& count) = 0;

    /**
     * Gets the number of rendered frames (this value should reset to zero on flush()).
     * @param count out parameter number of rendered frames
     */
    virtual MediaResult getRenderedFrames(int& count) = 0;

    /**
     * Sets the video surface to render video to. The type of pointer is platform dependent.
     * @param surface handle to a surface object to set
     */
    virtual MediaResult setSurface(void* surface)
    {
        // TODO make pure
        (void)surface;
        return MediaResult::Ok;
    };
};
}
