#pragma once

#include "playercore/platform/NativePlatform.hpp"
#include <jni.h>

namespace twitch {
/**
 * Platform specific API for Android.
 */
class AndroidPlatform : public NativePlatform {
public:
    /**
     * Initializes the Android Platform. This should be called once when the shared library
     * containing the player code is loaded.
     *
     * @param vm Java VM
     */
    static void initialize(JavaVM* vm);

    /**
     * Creates a AndroidPlatform instance
     * @param env Java environment
     * @param context Android Context object should be a Java object of type
     * (see https://developer.android.com/reference/android/content/Context) normally this is the
     * Activity or Application Context.
     * @return shared pointer to a AndroidPlatform instance which can be given to Player::create
     */
    static std::shared_ptr<AndroidPlatform> create(JNIEnv* env, jobject context);

    ~AndroidPlatform() override = default;

    /**
     * Sets an override for the platform name, the default is "android" but for certain uses cases
     * this may need to modified by the calling application.
     * @param name to set
     */
    virtual void setName(const std::string& name) = 0;
};
}
