#pragma once

#include "playercore/platform/NativePlatform.hpp"

namespace twitch {
/**
 * Platform specific API for iOS/tvOS.
 */
class IOSPlatform : public NativePlatform {
public:
    /**
     * Creates a IOSPlatform instance
     * @return shared pointer to a IOSPlatform instance which can be given to Player::create
     */
    static std::shared_ptr<IOSPlatform> create();

    ~IOSPlatform() override = default;

    virtual void setPassthroughMode(bool enabled) = 0;
};
}
