#pragma once
#include "playercore/log.hpp"
#include <string>
#include <videodec2.h>

namespace twitch {
namespace ps4 {
/**
 *  Configuration options for initializating the Player Core library
 */
struct Configuration {
    Configuration() = default;

    /**
     * If enabled, PlayerCore will initialize the SCE app content library
     */
    bool InitializeAdditionalContent = true;

    /**
     * The device identification string
     */
    std::string deviceId;

    /**
     * Fallback directory to use if Player Core cannot mount the temp directory
     */
    std::string downloadDir = "/download0";

    /**
     * Logging level for the Player Core library
     */
    Log::Level logLevel = Log::Level::Debug;

    /**
     * Number of buffers used for frame buffer pool
     */
    int frameBufferCount = 8;

    /**
      * Maximum width supported for the video decoding
     */
    int maxWidth = 1920;

    /**
      * Maximum height supported for the video decoding
     */
    int maxHeight = 1088;

    /**
      * Maximum level supported for the video decoding
     */
    int maxAvcLevel = SCE_VIDEODEC2_AVC_LEVEL_5_2;

    /**
     * Maximum profile supported for the video decoding
     */
    int maxAvcProfile = SCE_VIDEODEC2_AVC_PROFILE_HIGH;

    /**
      * Pipeline depth for the video decoding
     */
    int pipelineDepth = 8;

    /**
     * Maximum DPB (decoded picture buffer) supported for the video decoding
     */
    int maxDpbFrameCount = 5;
};
}
}
