#pragma once

#include "playercore/platform/HttpClient.hpp"
#include "playercore/platform/NativePlatform.hpp"
#include "playercore/platform/ps4/PlayerCore.hpp"
#include <string>

namespace twitch {
class PS4Platform : public NativePlatform {
public:
    // Callback for when the VideoFrameBuffer is available
    using OnVideoFrameBuffer = ps4::PlayerCore::OnVideoFrameBuffer;
    using OnFrameNeedsReleasing = ps4::PlayerCore::OnFrameNeedsReleasing;

    PS4Platform(OnVideoFrameBuffer onVideoFrameBuffer = OnVideoFrameBuffer(), OnFrameNeedsReleasing onFrameNeedsReleasing = OnFrameNeedsReleasing(), const std::string& deviceId = "");
    ~PS4Platform();

    std::unique_ptr<MediaDecoder> createDecoder(std::shared_ptr<const MediaFormat>) override;
    std::unique_ptr<MediaRenderer> createRenderer(const ReferenceClock& clock, std::shared_ptr<const MediaFormat>) override;
    std::shared_ptr<Scheduler> createScheduler(const std::string& name) override;
    std::shared_ptr<Log> getLog() const override { return m_log; }
    std::shared_ptr<HttpClient> getHttpClient() const override { return m_httpClient; }
    const std::string& getName() const override { return m_name; }
    const std::string& getTempPath() const override;
    const Capabilities& getCapabilities() const override { return m_capabilities; }
    VideoDecoderCapabilities getVideoDecoderCapabilities(const MediaType& mediaType) override;
    void onThreadCreated(std::thread::id id, const std::string& name) override;
    void setCurrentThreadName(const std::string& name) override;

    static void sceErrorToString(int errorCode, std::string& canonical, std::string& description);
    static void traceError(const std::string& errMsg, int errorCode);

private:
    OnVideoFrameBuffer m_onVideoFrameBuffer;
    OnFrameNeedsReleasing m_onFrameNeedsReleasing;

    Capabilities m_capabilities;
    static std::shared_ptr<Log> m_log;
    static const std::string m_name;

    // pre-allocate VideoDecoder because it uses so much linear memory
    std::unique_ptr<MediaDecoder> m_videoDecoder;

protected:
    std::shared_ptr<HttpClient> m_httpClient; // HttpClient depends on Configuration for its onThreadCreated callback, so it needs to be created later.
};
}
