#pragma once

#include "playercore/MediaTime.hpp"
#include <memory>
#include <videodec2.h>

namespace twitch {

/**
 *  VideoFrame interface for decoded video frames passed by the MediaRenderer to
 *  the client to render
 */
class VideoFrame {
public:
    virtual ~VideoFrame() = default;

    /**
     *  Get the decoded video output info
     *  @return SceVideodec2OutputInfo decoded video output info
     */
    virtual const SceVideodec2OutputInfo& getOutputInfo() const = 0;

    /**
     *  Get the decoded video picture info. The picture info contains extra information (such as cropping) of the decoded video frame
     *  @return SceVideodec2AvcPictureInfo decoded video output picture info
     */
    virtual const SceVideodec2AvcPictureInfo& getPictureInfo() const = 0;

    /**
     *  Finish function to call when the renderer has completed rendering.
     */
    virtual void finish() = 0;
};

/**
 *  Interface that the Player Core will provide to allow other render loops to
 *  get the most recent frame quickly
 */
class VideoFrameBuffer {
public:
    virtual std::shared_ptr<VideoFrame> getFrame() = 0;
};
}
