#pragma once
#include "WindowsPlatform.hpp"
#include "playercore/Player.hpp"

namespace twitch {
namespace windows {
class PlayerCore {
public:
    /**
     * Callback for when the rendered frames are available
     */
    using OnRenderFrame = WindowsPlatform::OnRenderFrame;

    /**
     * Create a Player instance for video playback
     * @param listener player event listeners
     * @param onRenderFrame callback function for receiving rendered frames
     * @return twitch::Player instance if the player was successfully created, otherwise nullptr
     */
    static std::shared_ptr<twitch::Player> create(twitch::Player::Listener& listener, OnRenderFrame onRenderFrame, Microsoft::WRL::ComPtr<ID3D11Device> device,
        MediaSource::Request::Listener* requestListener = nullptr);

    static Microsoft::WRL::ComPtr<ID3D11Texture2D> getTextureFromVideoSample(const twitch::MediaSampleBuffer& videoSample);
};
}
}
