#pragma once

#include "playercore/Log.hpp"
#include "playercore/platform/HttpClient.hpp"
#include "playercore/platform/NativePlatform.hpp"
#include <functional>
#include <memory>
#include <string>

#ifdef __cplusplus_winrt
#include <d3d11_3.h>
#include <dxgi1_4.h>
#else
// https://docs.microsoft.com/en-us/windows/desktop/direct3darticles/platform-update-for-windows-7
#include <d3d11_1.h>
#include <dxgi1_2.h>
#endif
#include <mfobjects.h>
#include <wrl.h>

namespace twitch {
class WindowsPlatform : public twitch::NativePlatform {
public:
    std::unique_ptr<MediaDecoder> createDecoder(std::shared_ptr<const MediaFormat> format);
    std::unique_ptr<MediaRenderer> createRenderer(const ReferenceClock& clock, std::shared_ptr<const MediaFormat> format);
    std::shared_ptr<Log> getLog() const override;
    std::shared_ptr<twitch::HttpClient> getHttpClient() const override;
    const std::string& getName() const override;
    const std::string& getTempPath() const override;
    const Capabilities& getCapabilities() const override;
    VideoDecoderCapabilities getVideoDecoderCapabilities(const MediaType& mediaType) override;

    void setCurrentThreadName(const std::string& name) override;

    static void hError(const std::string& message, HRESULT errorCode);

    using OnRenderFrame = std::function<void(const MediaSampleBuffer&, int width, int height)>;
    WindowsPlatform(Microsoft::WRL::ComPtr<ID3D11Device> device, OnRenderFrame onRenderFrame = nullptr);

private:
    MediaResult SetupGraphics();

private:
    static const std::string m_name;
    std::string m_tempPath;
    Capabilities m_capabilities;
    std::shared_ptr<twitch::Log> m_log;
    std::shared_ptr<HttpClient> m_httpClient;
    OnRenderFrame m_onRenderFrame;
    Microsoft::WRL::ComPtr<ID3D11Device> m_device;
    Microsoft::WRL::ComPtr<IMFDXGIDeviceManager> m_dxgiManager;
    UINT m_deviceResetToken = 0;
};
}
