#include "ATrace.hpp"
#include <android/trace.h>
#include <dlfcn.h>

namespace twitch {
static void* (*s_ATrace_beginSection)(const char* name) = nullptr;
static void* (*s_ATrace_endSection)(void) = nullptr;

typedef void* (*fp_ATrace_beginSection)(const char* name);
typedef void* (*fp_ATrace_endSection)(void);

void ATrace::initialize()
{
// https://developer.android.com/ndk/reference/group/tracing
// ATrace_ not available until in NDK until API 23
#ifdef NDEBUG
    void* lib = dlopen("libandroid.so", RTLD_NOW | RTLD_LOCAL);
    if (lib) {
        s_ATrace_beginSection = reinterpret_cast<fp_ATrace_beginSection>(dlsym(lib, "ATrace_beginSection"));
        s_ATrace_endSection = reinterpret_cast<fp_ATrace_endSection>(dlsym(lib, "ATrace_endSection"));
    }
#endif
}

ATrace::ATrace(const char* name)
{
    if (s_ATrace_beginSection) {
        s_ATrace_beginSection(name);
    }
}

ATrace::~ATrace()
{
    if (s_ATrace_endSection) {
        s_ATrace_endSection();
    }
}
}
