#include "AttachThread.hpp"
#include <android/log.h>
#include <unistd.h>

namespace jni {
pthread_key_t AttachThread::s_key = 0;
pthread_once_t AttachThread::s_key_once = PTHREAD_ONCE_INIT;
const char* AttachThread::s_tag = "JNI";

AttachThread::AttachThread(JavaVM* vm)
    : m_env(NULL)
    , m_vm(vm)
{
}

JNIEnv* AttachThread::getEnv()
{
    if (!m_env && m_vm && m_vm->GetEnv(reinterpret_cast<void**>(&m_env), JNI_VERSION_1_6) == JNI_EDETACHED) {
        if (m_vm->AttachCurrentThread(&m_env, nullptr) == JNI_OK) {
            int result = pthread_setspecific(s_key, m_env);

            if (result) {
                __android_log_print(ANDROID_LOG_ERROR, s_tag, "pthread_setspecific failed: %d", result);
            }

            __android_log_print(ANDROID_LOG_DEBUG, s_tag, "Attached thread %d to VM", gettid());
        } else {
            __android_log_print(ANDROID_LOG_ERROR, s_tag, "Failed to attach thread to VM");
        }
    }

    return m_env;
}

void AttachThread::initialize()
{
    int result = pthread_once(&s_key_once, &createThreadKey);

    if (result) {
        __android_log_print(ANDROID_LOG_ERROR, s_tag, "pthread_once failed: %d", result);
    }
}

void AttachThread::createThreadKey()
{
    int result = pthread_key_create(&s_key, &detachThread);

    if (result) {
        __android_log_print(ANDROID_LOG_ERROR, s_tag, "pthread_key_create failed: %d", result);
    }
}

void AttachThread::detachThread(void* arg)
{
    if (!arg) {
        return;
    }

    JNIEnv* env = static_cast<JNIEnv*>(arg);
    JavaVM* vm = nullptr;
    int result = env->GetJavaVM(&vm);

    if (vm) {
        result = vm->DetachCurrentThread();

        if (result == JNI_OK) {
            __android_log_print(ANDROID_LOG_DEBUG, s_tag, "Detached thread %d from VM", gettid());
        } else {
            __android_log_print(ANDROID_LOG_ERROR, s_tag, "DetachCurrentThread failed: %d", result);
        }
    } else {
        __android_log_print(ANDROID_LOG_ERROR, s_tag, "GetJavaVM failed: %d", result);
    }
}
}
