#pragma once

#include <jni.h>
#include <pthread.h>

namespace jni {
class AttachThread {
public:
    AttachThread(JavaVM* vm);
    virtual ~AttachThread() = default;
    JNIEnv* getEnv();
    static void initialize();

    AttachThread(const AttachThread& other) = delete;
    const AttachThread& operator=(const AttachThread& other) = delete;

private:
    static pthread_key_t s_key;
    static pthread_once_t s_key_once;
    static const char* s_tag;

    static void createThreadKey();
    static void detachThread(void* arg);

    JNIEnv* m_env;
    JavaVM* m_vm;
};
}
