#include "AudioRendererJNI.hpp"

namespace twitch {
MediaResult AudioRendererJNI::setVolume(float volume)
{
    if (!m_object || !m_env) {
        return MediaResult::ErrorInvalidState;
    }

    m_env->CallVoidMethod(m_object, s_setVolume, static_cast<jfloat>(volume));
    return checkException();
}

}
