#pragma once

#include "MediaRendererJNI.hpp"
#include "jni_ref.hpp"
#include "playercore/MediaRenderer.hpp"

namespace twitch {
class AudioRendererJNI : public MediaRendererJNI, public AudioRenderer {
public:
    AudioRendererJNI(JNIEnv* env, jobject player, jobject decoder)
        : MediaRendererJNI(env, player, decoder)
    {
    }
    virtual ~AudioRendererJNI() = default;
    MediaResult setPlaybackRate(float rate) override { return MediaRendererJNI::setPlaybackRate(rate); };
    MediaResult setVolume(float volume) override;
    MediaResult start() override { return MediaRendererJNI::start(); }
    MediaResult stop() override { return MediaRendererJNI::stop(); }
    MediaResult flush() override { return MediaRendererJNI::flush(); }
    MediaResult configure(const MediaFormat& format) override
    {
        return MediaRendererJNI::configure(format);
    }
    MediaResult render(std::shared_ptr<const MediaSample> input) override
    {
        return MediaRendererJNI::render(input);
    }
    MediaResult getRenderedPresentationTime(MediaTime& time) override
    {
        return MediaRendererJNI::getRenderedPresentationTime(time);
    }
};

}
