#pragma once

#include "jni_ref.hpp"
#include "playercore/platform/DrmSession.hpp"

namespace twitch {
class DrmSessionJNI : public DrmSession {
public:
    DrmSessionJNI(JNIEnv* env, const std::vector<uint8_t>& system, DrmSession::Listener& listener);
    ~DrmSessionJNI() override;
    static void initialize(JNIEnv* env);
    static jobject create(JNIEnv* env, const std::vector<uint8_t>& system, DrmSessionJNI* ptr);
    DrmSession::Listener& getListener() { return m_listener; }

    void initialize() override;
    const std::string& getSessionId() const override;
    OpaqueRequest generateKeyRequest(const std::vector<uint8_t>& init) override;
    OpaqueRequest generateProvisionRequest() override;
    void updateKeyResponse(const std::vector<uint8_t>& data) override;
    void updateProvisionResponse(const std::vector<uint8_t>& data) override;

private:
    OpaqueRequest createRequest(JNIEnv* env, jobject requestObject);
    void checkException(JNIEnv* env);

    jni::GlobalRef<jobject> m_object;
    DrmSession::Listener& m_listener;
    mutable std::string m_sessionId;
    static jmethodID s_createSession;
    static jmethodID s_initialize;
    static jmethodID s_getSessionId;
    static jmethodID s_generateKeyRequest;
    static jmethodID s_generateProvisionRequest;
    static jmethodID s_updateKeyResponse;
    static jmethodID s_updateProvisionResponse;
    static jmethodID s_release;
    static jfieldID s_requestUrl;
    static jfieldID s_requestData;
    static jclass s_drmSession;
    static jclass s_opaqueRequest;
};
}
