#include "LogCat.hpp"
#include "platform/NativePlatform.hpp"
#include <android/log.h>

namespace twitch {
Logcat::Logcat(std::string tag)
    : m_tag(tag)
{
}
void Logcat::log(Level level, const char* format, va_list args) const
{
    if (level >= m_level) {
        int androidLevel;

        switch (level) {
        case Level::Info:
            androidLevel = ANDROID_LOG_INFO;
            break;

        case Level::Debug:
            androidLevel = ANDROID_LOG_DEBUG;
            break;

        case Level::Warning:
            androidLevel = ANDROID_LOG_WARN;
            break;

        case Level::Error:
            androidLevel = ANDROID_LOG_ERROR;
            break;
        }

        if (NativePlatform::getLogMessageHandler()) {
            const int MaxLength = 1024;
            char buf[MaxLength] = { '\0' };
            std::vsnprintf(buf, MaxLength, format, args);
            std::string line = buf;
            NativePlatform::getLogMessageHandler()(level, line);
        } else {
            __android_log_vprint(androidLevel, m_tag.c_str(), format, args);
        }
    }
}
}
