#pragma once

#include "playercore/Log.hpp"
#include <cstdarg>

namespace twitch {
// logs to adb logcat
class Logcat : public Log {
public:
    Logcat(std::string tag = "Twitch");
    void log(Level level, const char* format, va_list args) const override;
    void setLevel(Level level) override { m_level = level; }

private:
    std::string m_tag;
    Level m_level = Level::Debug;
};
}
