#pragma once

#include "jni_ref.hpp"
#include "playercore/MediaDecoder.hpp"

namespace twitch {
class MediaDecoderJNI : public MediaDecoder {
public:
    MediaDecoderJNI(JNIEnv* env, jobject platform, jobject decoder);
    virtual ~MediaDecoderJNI();
    MediaResult configure(const MediaFormat& input, MediaFormat& output) override;
    MediaResult decode(const MediaSampleBuffer& input) override;
    MediaResult hasOutput(bool& hasOutput) override;
    MediaResult getOutput(std::shared_ptr<MediaSample>& output) override;
    MediaResult flush() override;
    MediaResult reset() override;

    static void initialize(JNIEnv* env);
    static jobject createMediaFormat(JNIEnv* env, const MediaFormat& format);
    static jobject createMediaSample(JNIEnv* env, const MediaSampleBuffer& sample);

private:
    MediaResult checkException(MediaResult result = MediaResult::Ok);

    JNIEnv* m_env;
    jni::GlobalRef<jobject> m_platform;
    jni::GlobalRef<jobject> m_object;
    static jmethodID s_configure;
    static jmethodID s_decode;
    static jmethodID s_flush;
    static jmethodID s_release;
    static jmethodID s_reset;
    static jmethodID s_hasInput;
    static jmethodID s_hasOutput;
    static jmethodID s_getOutputTime;
    static jmethodID s_createAudioFormat;
    static jmethodID s_createVideoFormat;
    static jmethodID s_createTextFormat;
    static jmethodID s_createSample;
    static jmethodID s_createSecureSample;
    static jmethodID s_handleException;
    static jclass s_mediaFormats;
    static jclass s_mediaSample;
    static jclass s_byteBuffer;
};
}
