#pragma once

#include "jni_ref.hpp"
#include "player_jni.hpp"
#include "playercore/MediaRenderer.hpp"
#include "playercore/ReferenceClock.hpp"

namespace twitch {
class MediaRendererJNI : public MediaRenderer {
public:
    MediaRendererJNI(JNIEnv* env, jobject platform, jobject decoder);
    virtual ~MediaRendererJNI();
    MediaResult start() override;
    MediaResult stop() override;
    MediaResult configure(const MediaFormat& format) override;
    MediaResult flush() override;
    MediaResult render(std::shared_ptr<const MediaSample> input) override;
    MediaResult getRenderedPresentationTime(MediaTime& time) override;
    MediaResult setPlaybackRate(float rate) override;
    static void initialize(JNIEnv* env);

protected:
    MediaResult checkException(MediaResult result = MediaResult::Ok);

    JNIEnv* m_env;
    jni::GlobalRef<jobject> m_platform;
    jni::GlobalRef<jobject> m_object;
    static jmethodID s_getRenderedTime;
    static jmethodID s_configure;
    static jmethodID s_flush;
    static jmethodID s_release;
    static jmethodID s_render;
    static jmethodID s_start;
    static jmethodID s_stop;
    static jmethodID s_getDroppedFrames;
    static jmethodID s_getRenderedFrames;
    static jmethodID s_setSurface;
    static jmethodID s_setVolume;
    static jmethodID s_setPlaybackRate;
    static jmethodID s_setMediaTime;
    static jmethodID s_handleException;
};

}
