#pragma once

#include "jni_ref.hpp"
#include "playercore/platform/android/AndroidPlatform.hpp"

namespace twitch {
class PlatformJNI : public AndroidPlatform {
public:
    static void initialize(JavaVM* vm);

    PlatformJNI(JNIEnv* env, jobject context, jclass platformClass);
    PlatformJNI(JNIEnv* env, jobject platform);
    ~PlatformJNI() override = default;

    std::unique_ptr<MediaDecoder> createDecoder(std::shared_ptr<const MediaFormat> format) override;
    std::unique_ptr<MediaRenderer> createRenderer(const ReferenceClock& clock, std::shared_ptr<const MediaFormat> format) override;
    std::unique_ptr<DrmSession> createDrmSession(const std::vector<uint8_t>& system, DrmSession::Listener& listener) override;
    std::shared_ptr<Log> getLog() const override { return m_log; }
    std::shared_ptr<HttpClient> getHttpClient() const override { return m_httpClient; }
    const std::string& getName() const override { return m_name; }
    const std::string& getTempPath() const override { return m_tempPath; }
    const Capabilities& getCapabilities() const override { return m_capabilities; }
    const std::set<MediaType>& getSupportedMediaTypes() const override;
    const std::set<std::vector<uint8_t>>& getSupportedProtectionSystems() const override;
    VideoDecoderCapabilities getVideoDecoderCapabilities(const MediaType& mediaType) override;
    void setCurrentThreadName(const std::string& name) override;
    void onThreadCreated(std::thread::id id, const std::string& name) override;
    void setName(const std::string& name) override { m_name = name; }
    void setTempPath(const std::string& value) { m_tempPath = value; }

    static int getApiLevel();

private:
    static void checkException(JNIEnv* env);
    std::string m_name;
    std::string m_tempPath;
    Capabilities m_capabilities;
    std::shared_ptr<Log> m_log;
    std::shared_ptr<HttpClient> m_httpClient;
    jni::GlobalRef<jobject> m_javaPlatform;
    jni::GlobalRef<jclass> m_platformClass;
    jni::GlobalRef<jclass> m_capabilitiesClass;
    static jmethodID s_createDecoder;
    static jmethodID s_createRenderer;
    static jmethodID s_getProtectionSystemUUIDs;
    static jmethodID s_getVideoDecoderCapabilities;
    static jmethodID s_onThreadCreated;

    static jfieldID s_capabilitiesMaxBitrate;
    static jfieldID s_capabilitiesMaxFramerate;
    static jfieldID s_capabilitiesMaxWidth;
    static jfieldID s_capabilitiesMaxHeight;
    static jfieldID s_capabilitiesMaxProfile;
    static jfieldID s_capabilitiesMaxLevel;
    static jmethodID s_capabilitiesVP9Supported;
};
}
