#include "VideoRendererJNI.hpp"
#include "package.hpp"

namespace twitch {
MediaResult VideoRendererJNI::render(std::shared_ptr<const MediaSample> input)
{
    MediaTime time = m_clock.getMediaTime();
    jlong timeUs = -1;
    if (time.valid()) {
        timeUs = time.microseconds().count();
    }
    m_env->CallVoidMethod(m_object, s_setMediaTime, timeUs);
    MediaResult result = checkException();
    if (result != MediaResult::Ok) {
        return result;
    }
    return MediaRendererJNI::render(input);
}

MediaResult VideoRendererJNI::getDroppedFrames(int& count)
{
    if (!m_object || !m_env) {
        return MediaResult::ErrorInvalidState;
    }
    count = m_env->CallIntMethod(m_object, s_getDroppedFrames);
    return checkException();
}

MediaResult VideoRendererJNI::getRenderedFrames(int& count)
{
    if (!m_object || !m_env) {
        return MediaResult::ErrorInvalidState;
    }
    count = m_env->CallIntMethod(m_object, s_getRenderedFrames);
    return checkException();
}

MediaResult VideoRendererJNI::setSurface(void* surface)
{
    auto surfaceObj = static_cast<jobject>(surface);
    m_env->CallVoidMethod(m_object, s_setSurface, surfaceObj);
    return checkException();
}
}
