#pragma once

#include "MediaRendererJNI.hpp"
#include "playercore/ReferenceClock.hpp"
#include "playercore/platform/VideoRenderer.hpp"

namespace twitch {
class VideoRendererJNI : public MediaRendererJNI, public VideoRenderer {
public:
    VideoRendererJNI(JNIEnv* env, jobject player, jobject decoder, const ReferenceClock& clock)
        : MediaRendererJNI(env, player, decoder)
        , m_clock(clock)
    {
    }
    virtual ~VideoRendererJNI() = default;
    MediaResult setPlaybackRate(float rate) override { return MediaRendererJNI::setPlaybackRate(rate); };
    MediaResult start() override { return MediaRendererJNI::start(); }
    MediaResult stop() override { return MediaRendererJNI::stop(); }
    MediaResult flush() override { return MediaRendererJNI::flush(); }
    MediaResult getDroppedFrames(int& count) override;
    MediaResult getRenderedFrames(int& count) override;
    MediaResult setSurface(void* surface) override;
    MediaResult configure(const MediaFormat& format) override
    {
        return MediaRendererJNI::configure(format);
    }
    MediaResult render(std::shared_ptr<const MediaSample> input) override;
    MediaResult getRenderedPresentationTime(MediaTime& time) override
    {
        return MediaRendererJNI::getRenderedPresentationTime(time);
    }

private:
    const ReferenceClock& m_clock;
};
}
