#pragma once

#include "AttachThread.hpp"
#include "jni_ref.hpp"
#include "playercore/platform/HttpClient.hpp"
#include <jni.h>

namespace twitch {

class HttpClientJNI : public HttpClient {
public:
    HttpClientJNI(JNIEnv* env);
    virtual ~HttpClientJNI();

    std::shared_ptr<HttpRequest> createRequest(const std::string& url, HttpMethod method = HttpMethod::GET) override;
    void send(std::shared_ptr<HttpRequest> request, ResponseHandler onResponse, ErrorHandler onError) override;

    static void initialize(JNIEnv* env);

    JNIEnv* m_env;
    jni::AttachThread m_attachThread;
    jni::GlobalRef<jobject> m_object;

    static jclass s_class;
    static jclass s_requestClass;
    static jclass s_responseClass;
    static jclass s_streamReadClass;
    static jclass s_callbackClass;
    static jmethodID s_classInit;
    static jmethodID s_clientExecute;
    static jmethodID s_clientRelease;
    static jmethodID s_requestInit;
    static jmethodID s_requestSetContent;
    static jmethodID s_requestSetTimeout;
    static jmethodID s_requestSetHeader;
    static jmethodID s_requestCancel;
    static jmethodID s_responseGetHeader;
    static jmethodID s_responseGetStatus;
    static jmethodID s_responseRead;
    static jmethodID s_streamReadInit;
    static jmethodID s_callbackInit;
};
}
