#pragma once

#include "PlatformJNI.hpp"
#include "player/MediaPlayer.hpp"
#include <jni.h>
#include <string>

namespace twitch {
class JNIWrapper final : public Player::Listener {
public:
    static void initialize(JNIEnv* env);

    JNIWrapper(JNIEnv* env, jobject player, jobject platform, jstring tempPath);
    ~JNIWrapper();

    void onError(const Error& error) override;
    void onDurationChanged(MediaTime duration) override;
    void onRebuffering() override;
    void onRecoverableError(const Error& error) override;
    void onSessionData(const std::map<std::string, std::string>& properties) override;
    void onStateChanged(MediaPlayer::State state) override;
    void onMetadata(const std::string& type, const std::vector<uint8_t>& data) override;
    void onQualityChanged(const Quality& quality) override;
    void onSeekCompleted(MediaTime time) override;
    void onAnalyticsEvent(const std::string& name, const std::string& properties) override;
    void onPositionChanged(MediaTime position) override;

    jobject createQuality(JNIEnv* env, const Quality& quality);

    std::shared_ptr<MediaPlayer> m_player;
    jni::AttachThread m_vmThread;
    jni::WeakGlobalRef<jobject> m_object;
    jni::GlobalRef<jobject> m_surface;
    jni::GlobalRef<jclass> m_qualityClass;

    static jmethodID s_playerHandleError;
    static jmethodID s_playerHandleQualityChange;
    static jmethodID s_playerHandleRebuffering;
    static jmethodID s_playerHandleStateChange;
    static jmethodID s_playerHandleMetadata;
    static jmethodID s_playerHandleAnalytics;
    static jmethodID s_playerInitQuality;

    static jfieldID s_statisticsBitRate;
    static jfieldID s_statisticsFrameRate;
    static jfieldID s_statisticsDecodedFrames;
    static jfieldID s_statisticsDroppedFrames;
    static jfieldID s_statisticsRenderedFrames;
};
}
