package tv.twitch.android.player;

class DrmListener implements DrmSession.Listener {

    private final long ptr;

    DrmListener(long ptr) {
        this.ptr = ptr;
    }

    private native void onKeyExpired(long ptr);
    private native void onKeyRequested(long ptr);
    private native void onProvisionRequested(long ptr);
    private native void onError(long ptr, String message);

    @Override
    public void onKeyExpired() {
        onKeyExpired(ptr);
    }

    @Override
    public void onKeyRequested() {
        onKeyRequested(ptr);
    }

    @Override
    public void onProvisionRequested() {
        onProvisionRequested(ptr);
    }

    @Override
    public void onError(String message) {
        onError(ptr, message);
    }
}
