package tv.twitch.android.player;

/**
 * Enumeration of error codes used in {@link Player.Listener#onError(MediaException)}.
 */
// must match the ordering in the native header file
public enum ErrorSource {
    /** Unspecified source */
    Unspecified,
    /** Error reading or opening a media file */
    File,
    /** Error downloading or parsing a media playlist */
    Playlist,
    /** Error downloading or parsing a media segment */
    Segment,
    /** Error from the media source */
    Source,
    /** Error from a MediaDecoder */
    Decode,
    /** Error from a MediaRenderer */
    Render;

    public static ErrorSource fromInt(int code) {
        if (code >= values().length) {
            return ErrorSource.Unspecified;
        }
        return values()[code];
    }
}
