package tv.twitch.android.player;

public class MediaException extends RuntimeException {

    private final ErrorSource source;
    private final MediaResult result;
    private final int code;
    private final String message;

    MediaException(MediaResult result, String message) {
        super(result + " : " + message);
        this.source = ErrorSource.Unspecified;
        this.result = result;
        this.code = 0;
        this.message = message;
    }

    MediaException(ErrorSource source, MediaResult result, int code, String message) {
        super(source + " : " + result + " : " + code + " : " + message);
        this.source = source;
        this.result = result;
        this.code = code;
        this.message = message;
    }

    MediaException(Throwable cause, ErrorSource source, MediaResult result, int code, String message) {
        super(source + " : " + result + " : " + code + " : " + message +
                (cause.getMessage() == null ? "" : " (" + cause.getMessage() + ")"), cause);
        this.source = source;
        this.result = result;
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return code;
    }

    public ErrorSource getSource() {
        return source;
    }

    public MediaResult getResult() {
        return result;
    }

    public String getErrorMessage() {
        return message;
    }
}
