package tv.twitch.android.player;

import android.media.MediaFormat;

import java.nio.ByteBuffer;

interface MediaRenderer extends Releasable {
    void configure(MediaFormat format);
    void render(ByteBuffer buffer, int size, long presentationTimeUs);
    void start();
    void stop();
    void release();
    void flush();
    long getRenderedPresentationTime();
    void setPlaybackRate(float rate);
}
