package tv.twitch.android.player;

/**
 * Enumeration of error codes used in {@link Player.Listener#onError(MediaException)}.
 */
// must match the ordering in the native header file
public enum MediaResult {
    Ok,
    Error,
    ErrorNotSupported,
    ErrorNoSource,
    ErrorInvalidData,
    ErrorInvalidState,
    ErrorInvalidParameter,
    ErrorTimeout,
    ErrorInvalidOutput,
    ErrorInternal,
    ErrorNetwork,
    ErrorNetworkIO,
    ErrorAuthorization,
    ErrorNotAvailable;

    public static MediaResult fromInt(int code) {
        if (code >= values().length) {
            return MediaResult.Error;
        }
        return values()[code];
    }
}
