package tv.twitch.android.player;

import android.media.MediaDrm;
import android.os.Build;

import java.util.EnumSet;
import java.util.UUID;

public enum ProtectionSystem {
    WIDEVINE(UUID.fromString("edef8ba9-79d6-4ace-a3c8-27dcd51d21ed")),
    PLAYREADY(UUID.fromString("9a04f079-9840-4286-ab92-e65be0885f95"));
    //CLEARKEY(UUID.fromString("e2719d58-a985-b3c9-781a-b030af78d30e"));

    private final UUID uuid;

    ProtectionSystem(UUID uuid) {
        this.uuid = uuid;
    }

    public UUID getUUID() {
        return uuid;
    }

    private static final EnumSet<ProtectionSystem> supported = EnumSet.noneOf(ProtectionSystem.class);

    public static EnumSet<ProtectionSystem> getSupported() {
        synchronized (supported) {
            if (supported.isEmpty()) {
                for (ProtectionSystem scheme : ProtectionSystem.values()) {
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR2) {
                        if (MediaDrm.isCryptoSchemeSupported(scheme.getUUID())) {
                            supported.add(scheme);
                        }
                    }
                }
            }
        }
        return supported;
    }

    public static ProtectionSystem valueOf(UUID uuid) {
        for(ProtectionSystem system : values()) {
            if (system.getUUID().equals(uuid)) {
                return system;
            }
        }
        return null;
    }
}
