package tv.twitch.android.player;

import java.util.Locale;

public final class Quality {

    private final String name;
    private final String type;
    private final String codecs;
    private final int bitrate;
    private final int width;
    private final int height;

    public Quality(String name, String type, String codecs, int bitrate, int width, int height) {
        this.name = name;
        this.type = type;
        this.codecs = codecs;
        this.bitrate = bitrate;
        this.width = width;
        this.height = height;
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT,
                "name: %s, type %s, bitrate %d, resolution %d x %d",
                name, type, bitrate, width, height);
    }

    public String getName() {
        return name;
    }

    public String getType() {
        return type;
    }

    public String getCodecs() {
        return codecs;
    }

    public int getBitrate() {
        return bitrate;
    }

    public int getWidth() {
        return width;
    }

    public int getHeight() {
        return height;
    }
}
